/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.EvaluationManager;
import org.eclipse.jdt.debug.eval.IClassFileEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIContentAssistPreference;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.actions.DisplayAction;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ISnippetStateChangedListener;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SelectImportsAction;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ShowInPackageViewAction;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.StopAction;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class JavaSnippetEditor
extends AbstractDecoratedTextEditor
implements IDebugEventFilter,
IEvaluationListener,
IValueDetailListener {
    static final String SCRAPBOOK_MAIN1_TYPE = "org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookMain1";
    static final String SCRAPBOOK_MAIN1_METHOD = "eval";
    private static final int SCRAPBOOK_MAIN1_LAST_LINE = 31;
    public static final String IMPORTS_CONTEXT = "SnippetEditor.imports";
    public static final int RESULT_DISPLAY = 1;
    public static final int RESULT_RUN = 2;
    public static final int RESULT_INSPECT = 3;
    private volatile int fResultMode;
    private IJavaProject fJavaProject;
    private IEvaluationContext fEvaluationContext;
    private IDebugTarget fVM;
    private String[] fLaunchedClassPath;
    private String fLaunchedWorkingDir;
    private String fLaunchedVMArgs;
    private IVMInstall fLaunchedVM;
    private List<ISnippetStateChangedListener> fSnippetStateListeners;
    private volatile boolean fEvaluating;
    private IJavaThread fThread;
    private volatile boolean fStepFiltersSetting;
    private int fSnippetStart;
    private int fSnippetEnd;
    private String[] fImports = null;
    private Image fOldTitleImage = null;
    private IClassFileEvaluationEngine fEngine = null;
    private IDebugModelPresentation fPresentation = DebugUITools.newDebugModelPresentation((String)JDIDebugModel.getPluginIdentifier());
    private String fResult;
    private IPartListener2 fActivationListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            if ("org.eclipse.jdt.debug.ui.SnippetEditor".equals(partRef.getId())) {
                System.setProperty(JDIDebugUIPlugin.getUniqueIdentifier() + ".scrapbookActive", "true");
            } else {
                System.setProperty(JDIDebugUIPlugin.getUniqueIdentifier() + ".scrapbookActive", "false");
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    };

    public JavaSnippetEditor() {
        this.setDocumentProvider(JDIDebugUIPlugin.getDefault().getSnippetDocumentProvider());
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{PreferenceConstants.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JavaSnippetViewerConfiguration(JDIDebugUIPlugin.getDefault().getJavaTextTools(), (IPreferenceStore)store, this));
        this.fSnippetStateListeners = new ArrayList<ISnippetStateChangedListener>(4);
        this.setPreferenceStore((IPreferenceStore)store);
        this.setEditorContextMenuId("#JavaSnippetEditorContext");
        this.setRulerContextMenuId("#JavaSnippetRulerContext");
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        String property;
        super.doSetInput(input);
        IFile file = this.getFile();
        if (file != null && (property = file.getPersistentProperty(new QualifiedName(JDIDebugUIPlugin.getUniqueIdentifier(), IMPORTS_CONTEXT))) != null) {
            this.fImports = JavaDebugOptionsManager.parseList(property);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.getWorkbenchWindow().getPartService().addPartListener(this.fActivationListener);
    }

    public void dispose() {
        this.shutDownVM();
        this.fPresentation.dispose();
        this.fSnippetStateListeners = null;
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            ((JDISourceViewer)viewer).dispose();
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fActivationListener);
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        if (this.getFile() != null) {
            TextOperationAction action = new TextOperationAction(SnippetMessages.getBundle(), "SnippetEditor.ContentAssistProposal.", (ITextEditor)this, 13);
            action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
            this.setAction("ContentAssistProposal", (IAction)action);
            this.setAction("ShowInPackageView", (IAction)new ShowInPackageViewAction(this));
            this.setAction("Stop", (IAction)new StopAction(this));
            this.setAction("SelectImports", (IAction)new SelectImportsAction(this));
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addGroup(menu, "group.edit", "group.generate");
        this.addGroup(menu, "group.find", "group.search");
        this.addGroup(menu, "group.search", "group.show");
        if (this.getFile() != null) {
            this.addAction(menu, "group.show", "ShowInPackageView");
            this.addAction(menu, "additions", "Run");
            this.addAction(menu, "additions", "Stop");
            this.addAction(menu, "additions", "SelectImports");
        }
    }

    protected boolean isVMLaunched() {
        return this.fVM != null;
    }

    public boolean isEvaluating() {
        return this.fEvaluating;
    }

    public void evalSelection(int resultMode) {
        if (!this.isInJavaProject()) {
            this.reportNotInJavaProjectError();
            return;
        }
        if (this.isEvaluating()) {
            return;
        }
        this.checkCurrentProject();
        this.evaluationStarts();
        this.fResultMode = resultMode;
        this.buildAndLaunch();
        if (this.fVM == null) {
            this.evaluationEnds();
            return;
        }
        this.fireEvalStateChanged();
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        String snippet = selection.getText();
        this.fSnippetStart = selection.getOffset();
        this.fSnippetEnd = this.fSnippetStart + selection.getLength();
        this.evaluate(snippet);
    }

    protected void checkCurrentProject() {
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        try {
            ILaunchConfiguration config = ScrapbookLauncher.getLaunchConfigurationTemplate(file);
            if (config != null) {
                String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                IJavaProject pro = JavaCore.create((IProject)file.getProject());
                if (!pro.getElementName().equals(projectName)) {
                    ScrapbookLauncher.setLaunchConfigMemento(file, null);
                }
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.evaluating"), null, (IStatus)ce.getStatus());
            this.evaluationEnds();
            return;
        }
    }

    protected void buildAndLaunch() {
        boolean launch;
        boolean build;
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return;
        }
        boolean bl = build = !javaProject.getProject().getWorkspace().isAutoBuilding() || !javaProject.hasBuildState();
        if (build && !this.performIncrementalBuild()) {
            return;
        }
        boolean changed = this.classPathHasChanged();
        if (!changed) {
            changed = this.workingDirHasChanged();
        }
        if (!changed) {
            changed = this.vmHasChanged();
        }
        if (!changed) {
            changed = this.vmArgsChanged();
        }
        boolean bl2 = launch = this.fVM == null || changed;
        if (changed) {
            this.shutDownVM();
        }
        if (this.fVM == null) {
            this.checkMultipleEditors();
        }
        if (launch && this.fVM == null) {
            this.launchVM();
            this.fVM = ScrapbookLauncher.getDefault().getDebugTarget(this.getFile());
        }
    }

    protected boolean performIncrementalBuild() {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    JavaSnippetEditor.this.getJavaProject().getProject().build(10, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, r);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
            this.evaluationEnds();
            return false;
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
            this.evaluationEnds();
            return false;
        }
        return true;
    }

    protected void checkMultipleEditors() {
        this.fVM = ScrapbookLauncher.getDefault().getDebugTarget(this.getFile());
        if (this.fVM != null) {
            DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
            try {
                IThread[] iThreadArray = this.fVM.getThreads();
                int n = iThreadArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IThread thread = iThreadArray[n2];
                    if (thread.isSuspended()) {
                        thread.resume();
                    }
                    ++n2;
                }
            }
            catch (DebugException de) {
                JDIDebugUIPlugin.log(de);
            }
        }
    }

    protected void setImports(String[] imports) {
        this.fImports = imports;
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        String serialized = null;
        if (imports != null) {
            serialized = JavaDebugOptionsManager.serializeList(imports);
        }
        try {
            file.setPersistentProperty(new QualifiedName(JDIDebugUIPlugin.getUniqueIdentifier(), IMPORTS_CONTEXT), serialized);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.imports"), null, (IStatus)e.getStatus());
        }
    }

    protected String[] getImports() {
        return this.fImports;
    }

    protected IEvaluationContext getEvaluationContext() {
        IJavaProject project;
        if (this.fEvaluationContext == null && (project = this.getJavaProject()) != null) {
            this.fEvaluationContext = project.newEvaluationContext();
        }
        if (this.fEvaluationContext != null) {
            if (this.getImports() != null) {
                this.fEvaluationContext.setImports(this.getImports());
            } else {
                this.fEvaluationContext.setImports(new String[0]);
            }
        }
        return this.fEvaluationContext;
    }

    protected IJavaProject getJavaProject() {
        if (this.fJavaProject == null) {
            try {
                this.fJavaProject = this.findJavaProject();
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
                this.showError(e.getStatus());
            }
        }
        return this.fJavaProject;
    }

    protected void shutDownVM() {
        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this);
        IDebugTarget target = this.fVM;
        if (this.fVM != null) {
            try {
                IBreakpoint bp = ScrapbookLauncher.getDefault().getMagicBreakpoint(this.fVM);
                if (bp != null) {
                    this.fVM.breakpointRemoved(bp, null);
                }
                if (this.getThread() != null) {
                    this.getThread().resume();
                }
                this.fVM.terminate();
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
                ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.shutdown"), null, (IStatus)e.getStatus());
                return;
            }
            this.vmTerminated();
            ScrapbookLauncher.getDefault().cleanup(target);
        }
    }

    protected void vmTerminated() {
        this.fVM = null;
        this.fThread = null;
        this.fEvaluationContext = null;
        this.fLaunchedClassPath = null;
        if (this.fEngine != null) {
            this.fEngine.dispose();
        }
        this.fEngine = null;
        this.fireEvalStateChanged();
    }

    public void addSnippetStateChangedListener(ISnippetStateChangedListener listener) {
        if (this.fSnippetStateListeners != null && !this.fSnippetStateListeners.contains(listener)) {
            this.fSnippetStateListeners.add(listener);
        }
    }

    public void removeSnippetStateChangedListener(ISnippetStateChangedListener listener) {
        if (this.fSnippetStateListeners != null) {
            this.fSnippetStateListeners.remove(listener);
        }
    }

    protected void fireEvalStateChanged() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Shell shell = JavaSnippetEditor.this.getShell();
                if (JavaSnippetEditor.this.fSnippetStateListeners != null && shell != null && !shell.isDisposed()) {
                    for (ISnippetStateChangedListener listener : new ArrayList<ISnippetStateChangedListener>(JavaSnippetEditor.this.fSnippetStateListeners)) {
                        listener.snippetStateChanged(JavaSnippetEditor.this);
                    }
                }
            }
        };
        Shell shell = this.getShell();
        if (shell != null) {
            this.getShell().getDisplay().asyncExec(r);
        }
    }

    protected void evaluate(String snippet) {
        if (this.getThread() == null) {
            WaitThread eThread = new WaitThread(Display.getCurrent(), (Object)this);
            eThread.start();
            eThread.block();
        }
        if (this.getThread() == null) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Evaluation failed: internal error - unable to obtain an execution context.", null);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.evaluating"), null, (IStatus)status);
            this.evaluationEnds();
            return;
        }
        boolean hitBreakpoints = Platform.getPreferencesService().getBoolean(JDIDebugPlugin.getUniqueIdentifier(), JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION, true, null);
        try {
            this.getEvaluationEngine().evaluate(snippet, this.getThread(), (IEvaluationListener)this, hitBreakpoints);
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.evaluating"), null, (IStatus)e.getStatus());
            this.evaluationEnds();
        }
    }

    public void evaluationComplete(IEvaluationResult result) {
        IJavaValue value;
        boolean severeErrors = false;
        if (result.hasErrors()) {
            String[] errors = result.getErrorMessages();
            boolean bl = severeErrors = errors.length > 0;
            if (result.getException() != null) {
                this.showException(result.getException());
            }
            this.showAllErrors(errors);
        }
        if ((value = result.getValue()) != null && !severeErrors) {
            switch (this.fResultMode) {
                case 1: {
                    this.displayResult(value);
                    break;
                }
                case 3: {
                    JavaInspectExpression exp = new JavaInspectExpression(result.getSnippet().trim(), value);
                    this.showExpression(exp);
                    break;
                }
            }
        }
        this.evaluationEnds();
    }

    protected void showExpressionView() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
                if (page != null) {
                    IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
                    if (part == null) {
                        try {
                            page.showView("org.eclipse.debug.ui.ExpressionView");
                        }
                        catch (PartInitException e) {
                            JDIDebugUIPlugin.log(e);
                            JavaSnippetEditor.this.showError(e.getStatus());
                        }
                    } else {
                        page.bringToTop((IWorkbenchPart)part);
                    }
                }
            }
        };
        this.async(r);
    }

    protected void codeComplete(CompletionRequestor requestor) throws JavaModelException {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        int start = selection.getOffset();
        String snippet = this.getSourceViewer().getDocument().get();
        IEvaluationContext e = this.getEvaluationContext();
        if (e != null) {
            e.codeComplete(snippet, start, requestor);
        }
    }

    protected IJavaElement[] codeResolve() throws JavaModelException {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        int start = selection.getOffset();
        int len = selection.getLength();
        String snippet = viewer.getDocument().get();
        IEvaluationContext e = this.getEvaluationContext();
        if (e != null) {
            return e.codeSelect(snippet, start, len);
        }
        return null;
    }

    protected void showError(IStatus status) {
        this.evaluationEnds();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.evaluating2"), null, (IStatus)status);
        }
    }

    protected void showError(String message) {
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, message, null);
        this.showError((IStatus)status);
    }

    protected void displayResult(IJavaValue result) {
        StringBuilder resultString = new StringBuilder();
        try {
            IJavaType type = result.getJavaType();
            if (type != null) {
                String sig = type.getSignature();
                if ("V".equals(sig)) {
                    resultString.append(SnippetMessages.getString("SnippetEditor.noreturnvalue"));
                } else {
                    if (sig != null) {
                        resultString.append(SnippetMessages.getFormattedString("SnippetEditor.typename", result.getReferenceTypeName()));
                    } else {
                        resultString.append(" ");
                    }
                    resultString.append(DisplayAction.trimDisplayResult(this.evaluateToString(result)));
                }
            } else {
                resultString.append(DisplayAction.trimDisplayResult(result.getValueString()));
            }
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.error.toString"), null, (IStatus)e.getStatus());
        }
        final String message = resultString.toString();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    JavaSnippetEditor.this.getSourceViewer().getDocument().replace(JavaSnippetEditor.this.fSnippetEnd, 0, message);
                    JavaSnippetEditor.this.selectAndReveal(JavaSnippetEditor.this.fSnippetEnd, message.length());
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        this.async(r);
    }

    protected synchronized String evaluateToString(IJavaValue value) {
        this.fResult = null;
        this.fPresentation.computeDetail((IValue)value, (IValueDetailListener)this);
        if (this.fResult == null) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                return SnippetMessages.getString("SnippetEditor.error.interrupted");
            }
        }
        return this.fResult;
    }

    public synchronized void detailComputed(IValue value, String result) {
        this.fResult = result;
        ((Object)((Object)this)).notifyAll();
    }

    protected void showAllErrors(String[] errors) {
        IDocument document = this.getSourceViewer().getDocument();
        String delimiter = document.getLegalLineDelimiters()[0];
        final StringBuilder errorString = new StringBuilder();
        String[] stringArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            String error = stringArray[n2];
            errorString.append(error + delimiter);
            ++n2;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    JavaSnippetEditor.this.getSourceViewer().getDocument().replace(JavaSnippetEditor.this.fSnippetStart, 0, errorString.toString());
                    JavaSnippetEditor.this.selectAndReveal(JavaSnippetEditor.this.fSnippetStart, errorString.length());
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        this.async(r);
    }

    private void showExpression(final JavaInspectExpression expression) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                new InspectPopupDialog(JavaSnippetEditor.this.getShell(), EvaluateAction.getPopupAnchor(JavaSnippetEditor.this.getSourceViewer().getTextWidget()), "org.eclipse.jdt.debug.ui.commands.Inspect", (IExpression)expression).open();
            }
        };
        this.async(r);
    }

    protected void showException(Throwable exception) {
        DebugException de;
        Throwable t;
        if (exception instanceof DebugException && (t = (de = (DebugException)exception).getStatus().getException()) != null) {
            this.showUnderlyingException(t);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos, true);
        exception.printStackTrace(ps);
        final String message = bos.toString();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    JavaSnippetEditor.this.getSourceViewer().getDocument().replace(JavaSnippetEditor.this.fSnippetEnd, 0, message);
                    JavaSnippetEditor.this.selectAndReveal(JavaSnippetEditor.this.fSnippetEnd, message.length());
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        this.async(r);
    }

    protected void showUnderlyingException(Throwable t) {
        if (t instanceof InvocationException) {
            InvocationException ie = (InvocationException)t;
            ObjectReference ref = ie.exception();
            String eName = ref.referenceType().name();
            final String message = SnippetMessages.getFormattedString("SnippetEditor.exception", eName);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaSnippetEditor.this.getSourceViewer().getDocument().replace(JavaSnippetEditor.this.fSnippetEnd, 0, message);
                        JavaSnippetEditor.this.selectAndReveal(JavaSnippetEditor.this.fSnippetEnd, message.length());
                    }
                    catch (BadLocationException badLocationException) {}
                }
            };
            this.async(r);
        } else {
            this.showException(t);
        }
    }

    protected IJavaProject findJavaProject() throws CoreException {
        IProject p;
        IFile file = this.getFile();
        if (file != null && (p = file.getProject()).getNature("org.eclipse.jdt.core.javanature") != null) {
            return JavaCore.create((IProject)p);
        }
        return null;
    }

    protected boolean classPathHasChanged() {
        String[] classpath = this.getClassPath(this.getJavaProject());
        if (this.fLaunchedClassPath != null && !this.classPathsEqual(this.fLaunchedClassPath, classpath)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.warning"), (String)SnippetMessages.getString("SnippetEditor.warning.cpchange"));
            return true;
        }
        return false;
    }

    protected boolean workingDirHasChanged() {
        String wd = this.getWorkingDirectoryAttribute();
        boolean changed = false;
        if (wd == null || this.fLaunchedWorkingDir == null) {
            if (wd != this.fLaunchedWorkingDir) {
                changed = true;
            }
        } else if (!wd.equals(this.fLaunchedWorkingDir)) {
            changed = true;
        }
        if (changed && this.fVM != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.Warning_1"), (String)SnippetMessages.getString("SnippetEditor.The_working_directory_has_changed._Restarting_the_evaluation_context._2"));
        }
        return changed;
    }

    protected boolean vmArgsChanged() {
        String args = this.getVMArgsAttribute();
        boolean changed = false;
        if (args == null || this.fLaunchedVMArgs == null) {
            if (args != this.fLaunchedVMArgs) {
                changed = true;
            }
        } else if (!args.equals(this.fLaunchedVMArgs)) {
            changed = true;
        }
        if (changed && this.fVM != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.Warning_1"), (String)SnippetMessages.getString("SnippetEditor.1"));
        }
        return changed;
    }

    protected boolean vmHasChanged() {
        IVMInstall vm = this.getVMInstall();
        boolean changed = false;
        if (vm == null || this.fLaunchedVM == null) {
            if (vm != this.fLaunchedVM) {
                changed = true;
            }
        } else if (!vm.equals(this.fLaunchedVM)) {
            changed = true;
        }
        if (changed && this.fVM != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)SnippetMessages.getString("SnippetEditor.Warning_1"), (String)SnippetMessages.getString("SnippetEditor.The_JRE_has_changed._Restarting_the_evaluation_context._2"));
        }
        return changed;
    }

    protected boolean classPathsEqual(String[] path1, String[] path2) {
        if (path1.length != path2.length) {
            return false;
        }
        int i = 0;
        while (i < path1.length) {
            if (!path1[i].equals(path2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected synchronized void evaluationStarts() {
        if (this.fThread != null) {
            try {
                IJavaThread thread = this.fThread;
                this.fThread = null;
                thread.resume();
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
                this.showException(e);
                return;
            }
        }
        this.fEvaluating = true;
        this.setTitleImage();
        this.fireEvalStateChanged();
        this.showStatus(SnippetMessages.getString("SnippetEditor.evaluating"));
        this.getSourceViewer().setEditable(false);
    }

    protected void setTitleImage() {
        Image image = null;
        if (this.fEvaluating) {
            this.fOldTitleImage = this.getTitleImage();
            image = JavaDebugImages.get("IMG_OBJS_SNIPPET_EVALUATING");
        } else {
            image = this.fOldTitleImage;
            this.fOldTitleImage = null;
        }
        if (image != null) {
            this.setTitleImage(image);
        }
    }

    protected void evaluationEnds() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JavaSnippetEditor.this.fEvaluating = false;
                JavaSnippetEditor.this.setTitleImage();
                JavaSnippetEditor.this.fireEvalStateChanged();
                JavaSnippetEditor.this.showStatus("");
                JavaSnippetEditor.this.getSourceViewer().setEditable(true);
            }
        };
        this.async(r);
    }

    protected void showStatus(String message) {
        IEditorSite site = (IEditorSite)this.getSite();
        EditorActionBarContributor contributor = (EditorActionBarContributor)site.getActionBarContributor();
        contributor.getActionBars().getStatusLineManager().setMessage(message);
    }

    protected String[] getClassPath(IJavaProject project) {
        try {
            return JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            return new String[0];
        }
    }

    protected Shell getShell() {
        return this.getSite().getShell();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                DebugEvent e = debugEventArray[n2];
                Object source = e.getSource();
                if (source instanceof IDebugElement) {
                    IDebugElement de = (IDebugElement)source;
                    if (de instanceof IDebugTarget) {
                        if (de.getDebugTarget().equals(this.fVM) && e.getKind() == 8) {
                            this.setThread(null);
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    JavaSnippetEditor.this.vmTerminated();
                                }
                            };
                            this.getShell().getDisplay().asyncExec(r);
                        }
                    } else if (de instanceof IJavaThread && e.getKind() == 2) {
                        IJavaThread jt = (IJavaThread)de;
                        try {
                            if (jt.equals(this.getThread()) && e.getDetail() == 64) {
                                return null;
                            }
                            IJavaStackFrame f = (IJavaStackFrame)jt.getTopStackFrame();
                            if (f == null) break block13;
                            IJavaDebugTarget target = (IJavaDebugTarget)f.getDebugTarget();
                            IBreakpoint[] bps = jt.getBreakpoints();
                            int lineNumber = f.getLineNumber();
                            if (e.getDetail() == 8 && lineNumber >= 31 && f.getDeclaringTypeName().equals(SCRAPBOOK_MAIN1_TYPE) && jt.getDebugTarget() == this.fVM) {
                                target.setStepFiltersEnabled(this.fStepFiltersSetting);
                                this.setThread(jt);
                                return null;
                            }
                            if (e.getDetail() == 16 && bps.length > 0 && bps[0].equals(ScrapbookLauncher.getDefault().getMagicBreakpoint(jt.getDebugTarget()))) {
                                IStackFrame[] iStackFrameArray = jt.getStackFrames();
                                int n3 = iStackFrameArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IStackFrame stackframe = iStackFrameArray[n4];
                                    IJavaStackFrame frame = (IJavaStackFrame)stackframe;
                                    if (frame.getReceivingTypeName().equals(SCRAPBOOK_MAIN1_TYPE) && frame.getName().equals(SCRAPBOOK_MAIN1_METHOD)) {
                                        this.fStepFiltersSetting = target.isStepFiltersEnabled();
                                        target.setStepFiltersEnabled(false);
                                        frame.stepOver();
                                        return null;
                                    }
                                    ++n4;
                                }
                            }
                        }
                        catch (DebugException ex) {
                            JDIDebugUIPlugin.log(ex);
                        }
                    }
                }
            }
            ++n2;
        }
        return events;
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        JavaSourceViewerConfiguration sourceViewerConfiguration = (JavaSourceViewerConfiguration)this.getSourceViewerConfiguration();
        return sourceViewerConfiguration.affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        JDISourceViewer isv = (JDISourceViewer)this.getSourceViewer();
        if (isv != null) {
            JavaSourceViewerConfiguration jsv;
            SourceViewerConfiguration configuration;
            IContentAssistant assistant = isv.getContentAssistant();
            if (assistant instanceof ContentAssistant) {
                JDIContentAssistPreference.changeConfiguration((ContentAssistant)assistant, event);
            }
            if ((configuration = this.getSourceViewerConfiguration()) instanceof JavaSourceViewerConfiguration && (jsv = (JavaSourceViewerConfiguration)configuration).affectsTextPresentation(event)) {
                jsv.handlePropertyChangeEvent(event);
                isv.invalidateTextPresentation();
            }
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected IJavaThread getThread() {
        return this.fThread;
    }

    protected synchronized void setThread(IJavaThread thread) {
        this.fThread = thread;
        ((Object)((Object)this)).notifyAll();
    }

    protected void launchVM() {
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
        this.fLaunchedClassPath = this.getClassPath(this.getJavaProject());
        this.fLaunchedWorkingDir = this.getWorkingDirectoryAttribute();
        this.fLaunchedVMArgs = this.getVMArgsAttribute();
        this.fLaunchedVM = this.getVMInstall();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ScrapbookLauncher.getDefault().launch(JavaSnippetEditor.this.getFile());
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
    }

    public IFile getFile() {
        IEditorInput input = this.getEditorInput();
        return (IFile)input.getAdapter(IFile.class);
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        this.fireEvalStateChanged();
    }

    protected void setPartName(String title) {
        this.cleanupOnRenameOrMove();
        super.setPartName(title);
    }

    protected void cleanupOnRenameOrMove() {
        if (this.isVMLaunched()) {
            this.shutDownVM();
        } else {
            this.fThread = null;
            this.fEvaluationContext = null;
            this.fLaunchedClassPath = null;
            if (this.fEngine != null) {
                this.fEngine.dispose();
                this.fEngine = null;
            }
        }
        this.fJavaProject = null;
    }

    protected boolean isInJavaProject() {
        try {
            return this.findJavaProject() != null;
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
            return false;
        }
    }

    protected void reportNotInJavaProjectError() {
        String projectName = null;
        IFile file = this.getFile();
        if (file != null) {
            IProject p = file.getProject();
            projectName = p.getName();
        }
        Object message = "";
        if (projectName != null) {
            message = projectName + SnippetMessages.getString("JavaSnippetEditor._is_not_a_Java_Project._n_1");
        }
        this.showError((String)message + SnippetMessages.getString("JavaSnippetEditor.Unable_to_perform_evaluation_outside_of_a_Java_Project_2"));
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block13: {
            Shell shell = this.getSite().getShell();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            dialog.open();
            IPath path = dialog.getResult();
            if (path == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(path);
            FileEditorInput newInput = new FileEditorInput(file);
            WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
                private final /* synthetic */ IEditorInput val$newInput;
                {
                    this.val$newInput = iEditorInput;
                }

                public void execute(IProgressMonitor monitor) throws CoreException {
                    IDocumentProvider dp = JavaSnippetEditor.this.getDocumentProvider();
                    dp.saveDocument(monitor, (Object)this.val$newInput, dp.getDocument((Object)JavaSnippetEditor.this.getEditorInput()), true);
                }
            };
            success = false;
            try {
                this.getDocumentProvider().aboutToChange((Object)newInput);
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
                success = true;
            }
            catch (InterruptedException interruptedException) {
                this.getDocumentProvider().changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                break block13;
            }
            catch (InvocationTargetException x) {
                try {
                    JDIDebugUIPlugin.log(x);
                    String title = SnippetMessages.getString("JavaSnippetEditor.Problems_During_Save_As..._3");
                    String msg = SnippetMessages.getString("JavaSnippetEditor.Save_could_not_be_completed.__4") + x.getTargetException().getMessage();
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.getDocumentProvider().changed((Object)newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                }
            }
            this.getDocumentProvider().changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected IClassFileEvaluationEngine getEvaluationEngine() {
        if (this.fEngine == null) {
            IPath outputLocation = this.getJavaProject().getProject().getWorkingLocation(JDIDebugUIPlugin.getUniqueIdentifier());
            File f = new File(outputLocation.toOSString());
            this.fEngine = EvaluationManager.newClassFileEvaluationEngine((IJavaProject)this.getJavaProject(), (IJavaDebugTarget)((IJavaDebugTarget)this.getThread().getDebugTarget()), (File)f);
        }
        if (this.getImports() != null) {
            this.fEngine.setImports(this.getImports());
        } else {
            this.fEngine.setImports(new String[0]);
        }
        return this.fEngine;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        JDISourceViewer viewer = new JDISourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles | 0x2000000);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected String getWorkingDirectoryAttribute() {
        IFile file = this.getFile();
        if (file != null) {
            try {
                return ScrapbookLauncher.getWorkingDirectoryAttribute(file);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    protected String getVMArgsAttribute() {
        IFile file = this.getFile();
        if (file != null) {
            try {
                return ScrapbookLauncher.getVMArgsAttribute(file);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    protected IVMInstall getVMInstall() {
        IFile file = this.getFile();
        if (file != null) {
            try {
                return ScrapbookLauncher.getVMInstall(file);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    protected void async(Runnable r) {
        Control control = this.getVerticalRuler().getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(r);
        }
    }

    protected void showAndSelect(final String text, final int offset) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    JavaSnippetEditor.this.getSourceViewer().getDocument().replace(offset, 0, text);
                }
                catch (BadLocationException e) {
                    JDIDebugUIPlugin.log(e);
                }
                JavaSnippetEditor.this.selectAndReveal(offset, text.length());
            }
        };
        this.async(r);
    }

    public <T> T getAdapter(Class<T> required) {
        if (required == IShowInTargetList.class) {
            return (T)((IShowInTargetList)() -> new String[]{"org.eclipse.jdt.ui.PackageExplorer"});
        }
        return (T)super.getAdapter(required);
    }

    private static class WaitThread
    extends Thread {
        private Display fDisplay;
        private volatile boolean fContinueEventDispatching = true;
        private Object fLock;

        private WaitThread(Display display, Object lock) {
            super("Snippet Wait Thread");
            this.setDaemon(true);
            this.fDisplay = display;
            this.fLock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: {
                try {
                    try {
                        Object object = this.fLock;
                        synchronized (object) {
                            this.fLock.wait(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.fDisplay.syncExec(new Runnable(this){
                            final /* synthetic */ WaitThread this$1;
                            {
                                this.this$1 = waitThread;
                            }

                            @Override
                            public void run() {
                            }
                        });
                        this.fContinueEventDispatching = false;
                        this.fDisplay.asyncExec(null);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.fDisplay.syncExec(new /* invalid duplicate definition of identical inner class */);
                    this.fContinueEventDispatching = false;
                    this.fDisplay.asyncExec(null);
                    throw throwable;
                }
                this.fDisplay.syncExec(new /* invalid duplicate definition of identical inner class */);
                this.fContinueEventDispatching = false;
                this.fDisplay.asyncExec(null);
            }
        }

        protected void block() {
            if (this.fDisplay == Display.getCurrent()) {
                while (this.fContinueEventDispatching) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    this.fDisplay.sleep();
                }
            }
        }
    }
}

