/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.snippet.errors;

import com.advancedpwr.eclipse.dromi.dialogs.ErrorDialogBean;
import com.advancedpwr.eclipse.dromi.dialogs.SnippetEvaluationErrorDialog;
import com.advancedpwr.eclipse.dromi.snippet.errors.CatchAllErrorMatcher;
import com.advancedpwr.eclipse.dromi.snippet.errors.ClassCommentUnsupportedErrorMatcher;
import com.advancedpwr.eclipse.dromi.snippet.errors.MissingDependencyErrorMatcher;
import com.advancedpwr.eclipse.dromi.snippet.errors.SnippetErrorMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SnippetErrorProcessor {
    public static final String UNMATCHED_ERROR_MESSAGE = "No matchers matched error from action. Expected catch-all to match. Contact maintainers.";
    protected List<SnippetErrorMatcher> fieldMatchers;

    protected void setDefaultMatchers() {
        this.getMatchers().add(new MissingDependencyErrorMatcher());
        this.getMatchers().add(new ClassCommentUnsupportedErrorMatcher());
        this.getMatchers().add(new CatchAllErrorMatcher());
    }

    public List<SnippetErrorMatcher> getMatchers() {
        if (this.fieldMatchers == null) {
            this.setMatchers(new ArrayList<SnippetErrorMatcher>());
            this.setDefaultMatchers();
        }
        return this.fieldMatchers;
    }

    public void setMatchers(List<SnippetErrorMatcher> filters) {
        this.fieldMatchers = filters;
    }

    public ErrorDialogBean process(String snippet, String[] errors) {
        List<String> errorList = Arrays.asList(errors);
        String message = null;
        for (SnippetErrorMatcher filter : this.getMatchers()) {
            message = filter.process(errorList);
            if (message == null) continue;
            return this.buildErrorDialog(message, snippet, errorList);
        }
        return this.buildErrorDialog(UNMATCHED_ERROR_MESSAGE, snippet, errorList);
    }

    protected ErrorDialogBean buildErrorDialog(String message, String snippet, List<String> errorList) {
        message = "Dromi encountered an error while running a code snippet in the JDI VM:\n\n" + (String)message;
        return SnippetEvaluationErrorDialog.dialogWithSnippetErrors((String)message, snippet, errorList);
    }
}

