/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.recording;

import com.advancedpwr.eclipse.dromi.recording.SnippetEvaluationEngine;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;

public class SnippetEvaluator {
    public IEvaluationResult evaluteSnippet(String snippet) throws InvocationTargetException, DebugException, InterruptedException {
        IJavaStackFrame stackFrame = this.getStackFrameContext();
        if (stackFrame == null) {
            throw new RuntimeException("A stack frame must be selected to provide a context for an evaluation.");
        }
        if (!stackFrame.isSuspended()) {
            throw new InvocationTargetException(null, "Thread not suspended - unable to perform evaluation.");
        }
        IJavaProject project = this.getJavaProject((IStackFrame)stackFrame);
        if (project == null) {
            throw new InvocationTargetException(null, "Unable to evaluate the selected expression:\n\nTo perform an evaluation, an expression must be compiled in the context of a Java project's build path. The current execution context is not associated with a Java project in the workspace.");
        }
        SnippetEvaluationEngine engine = new SnippetEvaluationEngine(project, stackFrame);
        return engine.evalutateSnippet(snippet);
    }

    protected IJavaStackFrame getStackFrameContext() {
        IAdaptable debugContext = DebugUITools.getDebugContext();
        IJavaStackFrame frame = null;
        if (debugContext != null) {
            frame = (IJavaStackFrame)debugContext.getAdapter(IJavaStackFrame.class);
        }
        return frame;
    }

    protected IJavaProject getJavaProject(IStackFrame stackFrame) {
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        IJavaProject javaProject = null;
        if (stackFrame instanceof IJavaStackFrame) {
            javaProject = JavaDebugUtils.resolveJavaProject((IJavaStackFrame)((IJavaStackFrame)stackFrame));
        }
        return javaProject;
    }
}

