/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.recording;

import com.advancedpwr.eclipse.dromi.context.RecordingContext;
import com.advancedpwr.eclipse.dromi.dialogs.ErrorDialogBean;
import com.advancedpwr.eclipse.dromi.dialogs.ExceptionDialog;
import com.advancedpwr.eclipse.dromi.recording.SnippetEvaluator;
import com.advancedpwr.eclipse.dromi.snippet.URLClassloaderSnippetGenerator;
import com.advancedpwr.eclipse.dromi.snippet.errors.SnippetErrorProcessor;
import java.nio.file.Path;
import org.eclipse.jdt.debug.eval.IEvaluationResult;

public class BeanRecordAction {
    protected Path fieldDestination;
    protected String fieldClassname;
    protected RecordingContext fieldContext;

    public Path getDestination() {
        return this.fieldDestination;
    }

    public void setDestinationFolder(Path destination) {
        this.fieldDestination = destination;
    }

    protected String getClassname() {
        return this.fieldClassname;
    }

    protected void setClassname(String classname) {
        this.fieldClassname = classname;
    }

    public String removeExtension(String fileName) {
        if (fileName.indexOf(".") > 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public void setOutputPath(Path outputPath) {
        String noExtenstion = this.removeExtension(outputPath.toString());
        Path path = Path.of(noExtenstion, new String[0]);
        Object classname = path.getName(path.getNameCount() - 1).toString();
        if (!((String)classname).contains(".")) {
            classname = "." + (String)classname;
        }
        this.setClassname(this.getContext().variablePackage() + (String)classname);
        this.setDestinationFolder(path.getParent());
    }

    public RecordingContext getContext() {
        return this.fieldContext;
    }

    public void setContext(RecordingContext context) {
        this.fieldContext = context;
    }

    public void record() {
        IEvaluationResult result;
        SnippetEvaluator evaluator = new SnippetEvaluator();
        try {
            result = evaluator.evaluteSnippet(this.buildRecordSnippet());
        }
        catch (Exception e) {
            RuntimeException exception = new RuntimeException(e);
            throw exception;
        }
        this.handleResult(result);
    }

    protected String buildRecordSnippet() {
        URLClassloaderSnippetGenerator snippetGenerator = new URLClassloaderSnippetGenerator();
        snippetGenerator.setContext(this.getContext());
        snippetGenerator.setDestination(this.getDestination());
        snippetGenerator.setClassName(this.getClassname());
        return snippetGenerator.generate();
    }

    public void handleResult(IEvaluationResult result) {
        String[] errorMessages;
        if (result.getException() != null) {
            this.getContext().showErrorDialog(ExceptionDialog.dialogWithStackTrace("IEvaluationResult contained a DebugException", result.getException()));
        }
        if ((errorMessages = result.getErrorMessages()) != null && errorMessages.length > 0) {
            SnippetErrorProcessor errorMessageProcessor = new SnippetErrorProcessor();
            ErrorDialogBean errorDialog = errorMessageProcessor.process(result.getSnippet(), errorMessages);
            this.getContext().showErrorDialog(errorDialog);
        } else {
            this.getContext().refreshProjects();
        }
    }
}

