/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.preferences;

import com.advancedpwr.eclipse.dromi.DromiActivator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

public final class ProjectPreferenceStore
implements IPreferenceStore {
    protected IEclipsePreferences fieldProjectPreferences;
    protected IPreferenceStore fieldWorkbenchPreferenceStore;

    public ProjectPreferenceStore(IProject project) {
        this(new ProjectScope(project).getNode("com.advancedpwr.eclipse.dromi"), DromiActivator.getDefault().getPreferenceStore());
    }

    public ProjectPreferenceStore(IEclipsePreferences projectPreferences, IPreferenceStore workbenchPreferences) {
        this.setProjectPreferences(projectPreferences);
        this.setWorkbenchPreferenceStore(workbenchPreferences);
    }

    public IEclipsePreferences getProjectPreferences() {
        return this.fieldProjectPreferences;
    }

    public void setProjectPreferences(IEclipsePreferences preferenceStore) {
        this.fieldProjectPreferences = preferenceStore;
    }

    public IPreferenceStore getWorkbenchPreferenceStore() {
        return this.fieldWorkbenchPreferenceStore;
    }

    public void setWorkbenchPreferenceStore(IPreferenceStore workbenchPreferenceStore) {
        this.fieldWorkbenchPreferenceStore = workbenchPreferenceStore;
    }

    public boolean contains(String name) {
        return this.getProjectPreferences().get(name, null) != null;
    }

    public boolean getDefaultBoolean(String name) {
        return this.getWorkbenchPreferenceStore().getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.getWorkbenchPreferenceStore().getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.getWorkbenchPreferenceStore().getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.getWorkbenchPreferenceStore().getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.getWorkbenchPreferenceStore().getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.getWorkbenchPreferenceStore().getDefaultString(name);
    }

    public boolean isDefault(String name) {
        String defaultValue = this.getDefaultString(name);
        if (defaultValue == null) {
            return false;
        }
        return defaultValue.equals(this.getString(name));
    }

    public void setToDefault(String name) {
        String defaultValue = this.getDefaultString(name);
        this.setValue(name, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.getProjectPreferences().getBoolean(key, this.getDefaultBoolean(key));
    }

    public double getDouble(String key) {
        return this.getProjectPreferences().getDouble(key, this.getDefaultDouble(key));
    }

    public float getFloat(String key) {
        return this.getProjectPreferences().getFloat(key, this.getDefaultFloat(key));
    }

    public int getInt(String key) {
        return this.getProjectPreferences().getInt(key, this.getDefaultInt(key));
    }

    public long getLong(String key) {
        return this.getProjectPreferences().getLong(key, this.getDefaultLong(key));
    }

    public String getString(String key) {
        return this.getProjectPreferences().get(key, this.getDefaultString(key));
    }

    public void putValue(String name, String value) {
        this.setValue(name, value);
    }

    public void setValue(String key, double value) {
        this.getProjectPreferences().putDouble(key, value);
    }

    public void setValue(String key, float value) {
        this.getProjectPreferences().putFloat(key, value);
    }

    public void setValue(String key, int value) {
        this.getProjectPreferences().putInt(key, value);
    }

    public void setValue(String key, long value) {
        this.getProjectPreferences().putLong(key, value);
    }

    public void setValue(String key, String value) {
        this.getProjectPreferences().put(key, value);
    }

    public void setValue(String key, boolean value) {
        this.getProjectPreferences().putBoolean(key, value);
    }

    public void firePropertyChangeEvent(String arg0, Object arg1, Object arg2) {
    }

    public boolean needsSaving() {
        return false;
    }

    public void addPropertyChangeListener(IPropertyChangeListener arg0) {
    }

    public void removePropertyChangeListener(IPropertyChangeListener arg0) {
    }

    public void setDefault(String key, double value) {
    }

    public void setDefault(String key, float value) {
    }

    public void setDefault(String key, int value) {
    }

    public void setDefault(String key, long value) {
    }

    public void setDefault(String key, String value) {
    }

    public void setDefault(String key, boolean value) {
    }
}

