/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.preferences;

import com.advancedpwr.eclipse.dromi.DromiActivator;
import com.advancedpwr.eclipse.dromi.preferences.PreferenceConstants;
import com.advancedpwr.eclipse.dromi.preferences.PreferenceRetrievalEngine;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;

public class EclipsePreferenceRetrievalEngine
implements PreferenceRetrievalEngine {
    public IProject fieldProject;

    public IProject getProject() {
        return this.fieldProject;
    }

    public void setProject(IProject project) {
        this.fieldProject = project;
    }

    public EclipsePreferenceRetrievalEngine with(IProject project) {
        this.setProject(project);
        return this;
    }

    protected IPreferenceStore store() {
        return DromiActivator.getDefault().getPreferenceStore();
    }

    public IEclipsePreferences projectPreferences(IProject project) {
        return new ProjectScope(project).getNode("com.advancedpwr.eclipse.dromi");
    }

    public IEclipsePreferences instancePreferences() {
        return InstanceScope.INSTANCE.getNode("com.advancedpwr.eclipse.dromi");
    }

    @Override
    public String get(String key) {
        String fromProject = this.getFromProject(key);
        String fromInstance = this.getFromInstance(key);
        if (fromProject != null) {
            boolean isDefault = fromProject.equals(this.getDefault(key));
            if (fromInstance != fromProject && !isDefault) {
                return fromProject;
            }
        }
        return fromInstance;
    }

    protected String getDefault(String key) {
        return this.store().getDefaultString(key);
    }

    @Override
    public boolean getBoolean(String key) {
        String value;
        switch (value = this.get(key)) {
            case "false": {
                return false;
            }
            case "true": {
                return true;
            }
        }
        throw new RuntimeException("Warning: preference \"" + key + "\" is a boolean but has a string value of \"" + value + "\" which is not \"false\" or \"true\". Your preferences may be corrupt.");
    }

    protected String getFromProject(String key) {
        String projectPreference;
        IEclipsePreferences projectPreferences;
        if (this.getProject() != null && (projectPreferences = this.projectPreferences(this.getProject())) != null && (projectPreference = projectPreferences.get(key, null)) != null) {
            return projectPreference;
        }
        return null;
    }

    protected String getFromInstance(String key) {
        String value = this.instancePreferences().get(key, null);
        if (value == null) {
            this.instancePreferences().put(key, this.getDefault(key));
            value = this.instancePreferences().get(key, null);
        }
        return value;
    }

    @Override
    public Map<String, String> amalgamatePreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        for (String key : PreferenceConstants.allKeys()) {
            preferences.put(key, this.get(key));
        }
        return preferences;
    }
}

