/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.eclipse.wizard;

import com.advancedpwr.eclipse.dromi.context.RecordingContext;
import com.advancedpwr.eclipse.dromi.context.SimpleRecordingSettings;
import com.advancedpwr.eclipse.dromi.eclipse.wizard.RecordSettingsPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.Wizard;

public class RecordingWizard
extends Wizard {
    protected List<RecordSettingsPage> fieldSettingsPages;

    public RecordingWizard(List<RecordingContext> contexts) {
        for (RecordingContext context : contexts) {
            RecordSettingsPage page = new RecordSettingsPage(context);
            this.getSettingsPages().add(page);
            this.addPage(page);
        }
        this.setWindowTitle("[DROMI] Record Object State Wizard");
        this.setHelpAvailable(false);
    }

    public boolean performFinish() {
        for (RecordSettingsPage page : this.getSettingsPages()) {
            IPreferenceStore store = page.getPreferenceStore();
            String variableName = store.getString("variableName");
            page.getContext().setVariableNameForPathing(variableName);
            page.getContext().setSettings(new SimpleRecordingSettings().fromStore(store));
        }
        return true;
    }

    public List<RecordSettingsPage> getSettingsPages() {
        if (this.fieldSettingsPages == null) {
            this.fieldSettingsPages = new ArrayList<RecordSettingsPage>();
        }
        return this.fieldSettingsPages;
    }

    public void setSettingsPages(List<RecordSettingsPage> settingsPages) {
        this.fieldSettingsPages = settingsPages;
    }
}

