/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.eclipse.handlers;

import com.advancedpwr.eclipse.dromi.context.RecordingContext;
import com.advancedpwr.eclipse.dromi.dialogs.ErrorDialogBean;
import com.advancedpwr.eclipse.dromi.dialogs.ExceptionDialog;
import com.advancedpwr.eclipse.dromi.eclipse.context.EclipseRecordingContext;
import com.advancedpwr.eclipse.dromi.eclipse.context.EclipseRecordingSettings;
import com.advancedpwr.eclipse.dromi.eclipse.context.EclipseVariableSelector;
import com.advancedpwr.eclipse.dromi.eclipse.handlers.AbstractRecorder;
import com.advancedpwr.eclipse.dromi.eclipse.recording.job.RecordingManagerJob;
import com.advancedpwr.eclipse.dromi.preferences.EclipsePreferenceRetrievalEngine;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class EclipseRecordingHandler {
    protected EclipsePreferenceRetrievalEngine buildPreferenceEngine(IProject project) {
        EclipsePreferenceRetrievalEngine getter = new EclipsePreferenceRetrievalEngine();
        getter.setProject(project);
        return getter;
    }

    public abstract AbstractRecorder buildRecorder();

    public abstract RecordingManagerJob buildManagerJob();

    public void handleRecording(IStatusLineManager statusLineManager) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IJavaDebugTarget dbgContext = this.getDebugTarget();
            IProject debuggedProject = this.getDebuggedProject(dbgContext);
            EclipseRecordingSettings settings = new EclipseRecordingSettings(debuggedProject);
            List<IJavaVariable> selectedVariables = this.getSelectedVariables(window);
            ArrayList<RecordingContext> contexts = new ArrayList<RecordingContext>();
            for (IJavaVariable selectedVariable : selectedVariables) {
                EclipseRecordingContext context = new EclipseRecordingContext(settings, window, statusLineManager, debuggedProject, dbgContext, selectedVariable);
                contexts.add(context);
            }
            this.startRecordingJob(contexts);
        }
        catch (Exception e) {
            statusLineManager.setMessage("Dromi encountered an error.");
            ErrorDialogBean dialog = ExceptionDialog.dialogWithStackTrace("Dromi encountered an error while recording.", e);
            ErrorDialog.openError((Shell)window.getShell(), (String)dialog.getWindowTitle(), (String)dialog.getMessage(), (IStatus)dialog.getStatus());
        }
    }

    public void startRecordingJob(List<RecordingContext> contexts) {
        RecordingManagerJob job = this.buildManagerJob();
        job.setRecorder(this.buildRecorder());
        job.setContexts(contexts);
        job.schedule();
    }

    protected List<IJavaVariable> getSelectedVariables(IWorkbenchWindow window) {
        EclipseVariableSelector selector = new EclipseVariableSelector();
        ISelection selection = window.getSelectionService().getSelection();
        return selector.getSelectedVariables(selection);
    }

    protected IJavaDebugTarget getDebugTarget() {
        IJavaDebugTarget dbgContext = (IJavaDebugTarget)DebugUITools.getDebugContext().getAdapter(IJavaDebugTarget.class);
        if (dbgContext == null) {
            throw new IllegalStateException("Unable to get Java debug context: must run Dromi recorder in Java debugger.");
        }
        return dbgContext;
    }

    protected String getNames(List<IJavaVariable> selectedVariables) {
        StringBuilder str = new StringBuilder();
        int lastIndex = selectedVariables.size() - 1;
        str.append(selectedVariables.get(lastIndex));
        for (IJavaVariable variable : selectedVariables.subList(0, lastIndex)) {
            str.append(", ");
            str.append(variable);
        }
        return str.toString();
    }

    protected IProject getDebuggedProject(IJavaDebugTarget dbgContext) throws CoreException {
        List<String> launchResources = this.getLaunchResources(dbgContext);
        Path resourcePath = new Path(launchResources.get(0));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile containerForLocation = workspaceRoot.getFile((IPath)resourcePath);
        IProject debuggedProject = containerForLocation.getProject();
        if (debuggedProject == null) {
            throw new RuntimeException("Unable to get project from launch resources.");
        }
        return debuggedProject;
    }

    public List<String> getLaunchResources(IJavaDebugTarget dbgContext) throws CoreException {
        ILaunchConfiguration launchConfig = dbgContext.getProcess().getLaunch().getLaunchConfiguration();
        List launchResources = launchConfig.getAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, new ArrayList());
        if (launchResources.isEmpty()) {
            throw new RuntimeException("Unable to get resource paths from launch configuration.");
        }
        return launchResources;
    }
}

