/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.eclipse.context;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EclipseVariableSelector {
    protected void error(String message) {
        throw new RuntimeException(message);
    }

    public List<IJavaVariable> getSelectedVariables(ISelection selection) {
        List<IJavaVariable> variables;
        if (selection.isEmpty()) {
            this.error("Unable to get selected variable(s): window selection empty.");
        }
        if (!(selection instanceof IStructuredSelection)) {
            this.error("Unable to get selected variable(s): selection is not an instanceof IStructuredSelection.");
        }
        if ((variables = this.getJDIVariablesFromSelection((IStructuredSelection)selection)).isEmpty()) {
            this.error("Unable to get selected variable(s): window selection empty.");
        }
        return variables;
    }

    protected List<IJavaVariable> getJDIVariablesFromSelection(IStructuredSelection selection) {
        ArrayList<IJavaVariable> variables = new ArrayList<IJavaVariable>();
        Object first = selection.getFirstElement();
        if (first == null) {
            this.error("Unable to get selected variable(s): selection's first element is null.");
        }
        for (Object element : selection.toList()) {
            if (!(element instanceof IJavaVariable)) continue;
            variables.add((IJavaVariable)element);
        }
        if (variables.isEmpty()) {
            this.error("No items in the selection are Java variables.");
        }
        return variables;
    }
}

