/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.snippet;

import com.advancedpwr.eclipse.dromi.context.RecordingContext;
import com.advancedpwr.eclipse.dromi.snippet.SnippetVariableNamesBean;
import com.advancedpwr.eclipse.dromi.snippet.UniqueVariableGenerator;
import java.nio.file.Path;

public class URLClassloaderSnippetGenerator {
    protected static final String SET_CLASSNAME_METHOD = "setClassName";
    protected static final String SET_COMMENT_METHOD = "setClassComment";
    protected static final String SET_DESTINATION_METHOD = "setDestination";
    protected static final String RECORD_METHOD = "record";
    protected static final String SNIPPET_TEMPLATE = "java.net.URL thorURL = new java.net.URL( \"thorJarLocation\" );\njava.net.URL dromiURL = new java.net.URL( \"dromiJarLocation\" );\njava.net.URLClassLoader classLoader = new java.net.URLClassLoader( new java.net.URL[] { thorURL, dromiURL } );\nClass<?> recorderClass = classLoader.loadClass( \"beanRecorderClassname\" );\nObject recorderObject = recorderClass.getDeclaredConstructors()[0].newInstance((Object) null);\njava.lang.reflect.Method setClassCommentVar = recorderClass.getMethod( \"setClassCommentMethod\", String.class );\nsetClassCommentVar.invoke( recorderObject, \"Generated with the Dromi Eclipse plugin.\\nDromi is an Advanced Power product developed by Elijah Hopp.\" );\njava.lang.reflect.Method setDestinationVar = recorderClass.getMethod( \"setDestinationMethod\", String.class );\nsetDestinationVar.invoke( recorderObject, \"recordingDestination\" );\njava.lang.reflect.Method setClassNameVar = recorderClass.getMethod( \"setClassNameMethod\", String.class );\nsetClassNameVar.invoke( recorderObject, \"recordingClassName\" );\njava.lang.reflect.Method recordVariable = recorderClass.getMethod( \"recordMethod\", Object.class );\nrecordVariable.invoke( recorderObject, targetVariableName );";
    protected RecordingContext fieldContext;
    protected Path fieldDestination;
    protected String fieldClassName;
    protected UniqueVariableGenerator fieldVariableGenerator;
    protected SnippetVariableNamesBean fieldVariableNames;
    protected String fieldSnippet;

    public void setSnippet(String snippet) {
        this.fieldSnippet = snippet;
    }

    public String getSnippet() {
        if (this.fieldSnippet == null) {
            this.fieldSnippet = SNIPPET_TEMPLATE;
        }
        return this.fieldSnippet;
    }

    public String getClassName() {
        return this.fieldClassName;
    }

    public void setClassName(String className) {
        this.fieldClassName = className;
    }

    public void replace(String key, String value) {
        String replaced = this.getSnippet().replaceAll(key, value);
        this.setSnippet(replaced);
    }

    public String generate() {
        this.setSnippet(null);
        this.replace("thorURL", this.names().thorJarURL());
        this.replace("dromiURL", this.names().dromiShivJarURL());
        this.replace("thorJarLocation", this.thorJarPath());
        this.replace("dromiJarLocation", this.dromiShivJarPath());
        this.replace("classLoader", this.names().classloader());
        this.replace("recorderClass", this.names().recorderClass());
        this.replace("beanRecorderClassname", "com.advancedpwr.dromi.record.DromiEclipseBeanRecorder");
        this.replace("recorderObject", this.names().recorderObject());
        this.replace("setClassCommentMethod", SET_COMMENT_METHOD);
        this.replace("setClassCommentVar", this.names().commentSetter());
        this.replace("setDestinationMethod", SET_DESTINATION_METHOD);
        this.replace("setDestinationVar", this.names().destinationSetter());
        this.replace("recordingDestination", this.getDestinationAbsolutePath());
        this.replace("setClassNameMethod", SET_CLASSNAME_METHOD);
        this.replace("setClassNameVar", this.names().classNameSetter());
        this.replace("recordingClassName", this.getClassName());
        this.replace("recordMethod", RECORD_METHOD);
        this.replace("recordVariable", this.names().recordMethod());
        this.replace("targetVariableName", this.getContext().variableName());
        return this.getSnippet();
    }

    protected String thorJarPath() {
        return this.getContext().thorJarLocation().toExternalForm();
    }

    protected String dromiShivJarPath() {
        return this.getContext().dromiShivJarLocation().toExternalForm();
    }

    public RecordingContext getContext() {
        return this.fieldContext;
    }

    public void setContext(RecordingContext context) {
        this.fieldContext = context;
    }

    public Path getDestination() {
        return this.fieldDestination;
    }

    protected String getDestinationAbsolutePath() {
        return this.getDestination().toAbsolutePath().toString();
    }

    public void setDestination(Path destination) {
        this.fieldDestination = destination;
    }

    public SnippetVariableNamesBean getVariableNames() {
        if (this.fieldVariableNames == null) {
            this.setVariableNames(new SnippetVariableNamesBean());
            this.names().populate(this.getVariableGenerator());
        }
        return this.fieldVariableNames;
    }

    public void setVariableNames(SnippetVariableNamesBean variableNames) {
        this.fieldVariableNames = variableNames;
    }

    public SnippetVariableNamesBean names() {
        return this.getVariableNames();
    }

    public UniqueVariableGenerator getVariableGenerator() {
        if (this.fieldVariableGenerator == null) {
            this.setVariableGenerator(new UniqueVariableGenerator(this.getContext()));
        }
        return this.fieldVariableGenerator;
    }

    public void setVariableGenerator(UniqueVariableGenerator variableGenerator) {
        this.fieldVariableGenerator = variableGenerator;
    }
}

