/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.recording;

import java.util.concurrent.Semaphore;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;

public class SnippetEvaluationEngine
implements IEvaluationListener {
    protected IAstEvaluationEngine fieldEngine;
    protected IJavaStackFrame fieldStackFrame;
    protected Semaphore fieldLock;
    protected IEvaluationResult fieldResult;

    public SnippetEvaluationEngine(IJavaProject project, IJavaStackFrame stackFrame) {
        IJavaDebugTarget target = (IJavaDebugTarget)stackFrame.getDebugTarget();
        this.setEngine(JDIDebugPlugin.getDefault().getEvaluationEngine(project, target));
        this.setStackFrame(stackFrame);
    }

    public IEvaluationResult evalutateSnippet(String snippet) throws DebugException, InterruptedException {
        this.getLock().acquire();
        this.getEngine().evaluate(snippet, this.getStackFrame(), (IEvaluationListener)this, 64, false);
        this.getLock().acquire();
        this.getLock().release();
        IEvaluationResult result = this.getResult();
        this.setResult(null);
        return result;
    }

    public void evaluationComplete(IEvaluationResult result) {
        this.setResult(result);
        this.getLock().release();
    }

    public IAstEvaluationEngine getEngine() {
        return this.fieldEngine;
    }

    public void setEngine(IAstEvaluationEngine engine) {
        this.fieldEngine = engine;
    }

    public IJavaStackFrame getStackFrame() {
        return this.fieldStackFrame;
    }

    public void setStackFrame(IJavaStackFrame stackFrame) {
        this.fieldStackFrame = stackFrame;
    }

    public Semaphore getLock() {
        if (this.fieldLock == null) {
            this.setLock(new Semaphore(1));
        }
        return this.fieldLock;
    }

    public void setLock(Semaphore lock) {
        this.fieldLock = lock;
    }

    public IEvaluationResult getResult() {
        return this.fieldResult;
    }

    public void setResult(IEvaluationResult result) {
        this.fieldResult = result;
    }
}

