/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.pathing;

import com.advancedpwr.eclipse.dromi.context.RecordingContext;
import com.advancedpwr.eclipse.dromi.pathing.RecordingPathTemplater;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathGenerator {
    protected RecordingContext fieldContext;

    public RecordingContext getContext() {
        return this.fieldContext;
    }

    public void setContext(RecordingContext context) {
        this.fieldContext = context;
    }

    public PathGenerator withContext(RecordingContext context) {
        this.setContext(context);
        return this;
    }

    public String getDefaultSubDirectory() {
        return this.getContext().settings().destination();
    }

    protected String getOutputPattern() {
        return this.getContext().settings().outputPattern();
    }

    public Path getDestinationDirectory() {
        Path path = Paths.get(this.getDefaultSubDirectory(), new String[0]);
        if (!this.getDefaultSubDirectory().startsWith("/")) {
            path = this.getContext().projectLocation().resolve(path);
        }
        return path;
    }

    protected Path interpolatePath(String destinationDirectory, String variableName, String classname) {
        RecordingPathTemplater templater = new RecordingPathTemplater();
        templater.setPattern(this.getOutputPattern());
        templater.setDestinationDirectory(destinationDirectory);
        templater.setVariableName(variableName);
        templater.setClassname(classname);
        return Paths.get(templater.build(), new String[0]);
    }

    public Path generateFromContext() {
        return this.generate(this.getContext().variableNameForPathing(), this.getContext().variableClassname());
    }

    public Path generate(String variableName, String className) {
        Path destination = this.getDestinationDirectory();
        Path path = this.interpolatePath(destination.toString(), variableName, className);
        return path;
    }
}

