/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.eclipse.recording.job;

import com.advancedpwr.eclipse.dromi.context.RecordingContext;
import com.advancedpwr.eclipse.dromi.eclipse.handlers.AbstractRecorder;
import com.advancedpwr.eclipse.dromi.eclipse.recording.job.EclipseRecordTask;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;

public class RecordingManagerJob
extends Job {
    protected RecordingContext fieldUIContext;
    protected List<RecordingContext> fieldContexts;
    protected AbstractRecorder fieldRecorder;
    protected IStatusLineManager fieldStatusLineManager;

    public RecordingManagerJob(String name) {
        super(name);
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.setUIContext(this.getContexts().get(0));
        List<EclipseRecordTask> tasks = this.tasksFromContexts(this.getContexts());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)tasks.size());
        int completedTasks = 0;
        for (EclipseRecordTask task : tasks) {
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.setTaskName("Recording " + task.getContext().variableName());
            boolean completed = task.doRecording();
            if (completed) {
                ++completedTasks;
            }
            subMonitor.worked(1);
        }
        this.showStatusLine(completedTasks);
        return Status.OK_STATUS;
    }

    public List<EclipseRecordTask> tasksFromContexts(List<RecordingContext> contexts) {
        ArrayList<EclipseRecordTask> tasks = new ArrayList<EclipseRecordTask>();
        for (RecordingContext context : contexts) {
            EclipseRecordTask task = new EclipseRecordTask();
            task.setContext(context);
            task.setRecorder(this.getRecorder());
            tasks.add(task);
        }
        return tasks;
    }

    public void showStatusLine(int completedTasks) {
        String statusLine = completedTasks + " Dromi recording(s) completed.";
        this.getUIContext().setStatusLineMessage(statusLine);
    }

    public void showCanceledStatusLine() {
        this.getUIContext().setStatusLineMessage("Dromi recording canceled.");
    }

    public RecordingContext getUIContext() {
        return this.fieldUIContext;
    }

    public void setUIContext(RecordingContext uIContext) {
        this.fieldUIContext = uIContext;
    }

    public List<RecordingContext> getContexts() {
        if (this.fieldContexts == null) {
            this.setContexts(new ArrayList<RecordingContext>());
        }
        return this.fieldContexts;
    }

    public void setContexts(List<RecordingContext> contexts) {
        this.fieldContexts = contexts;
    }

    public AbstractRecorder getRecorder() {
        return this.fieldRecorder;
    }

    public void setRecorder(AbstractRecorder recorder) {
        this.fieldRecorder = recorder;
    }
}

