/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi.eclipse.context;

import com.advancedpwr.eclipse.dromi.DromiActivator;
import com.advancedpwr.eclipse.dromi.context.RecordingContext;
import com.advancedpwr.eclipse.dromi.context.RecordingSettings;
import com.advancedpwr.eclipse.dromi.dialogs.ErrorDialogBean;
import com.advancedpwr.eclipse.dromi.eclipse.context.EclipseContextPathVaildator;
import com.advancedpwr.eclipse.dromi.eclipse.context.VariableInfoBean;
import com.advancedpwr.eclipse.dromi.eclipse.wizard.EclipseWizardConfigurationBean;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EclipseRecordingContext
implements RecordingContext {
    protected IWorkbenchWindow fieldWindow;
    protected IStatusLineManager fieldStatusLineManager;
    protected IJavaDebugTarget fieldDebugContext;
    protected VariableInfoBean fieldSelectedVariable;
    protected IProject fieldDebuggedProject;
    protected RecordingSettings fieldSettings;

    public IWorkbenchWindow getWindow() {
        return this.fieldWindow;
    }

    public void setWindow(IWorkbenchWindow window) {
        this.fieldWindow = window;
    }

    public IJavaDebugTarget getDebugContext() {
        return this.fieldDebugContext;
    }

    public void setDebugContext(IJavaDebugTarget debugContext) {
        this.fieldDebugContext = debugContext;
    }

    public VariableInfoBean variable() {
        return this.fieldSelectedVariable;
    }

    public void setSelectedVariable(IJavaVariable selectedVariable) {
        try {
            this.fieldSelectedVariable = new VariableInfoBean().from(selectedVariable);
        }
        catch (DebugException e) {
            this.handleDebugException(e);
        }
    }

    public IProject getDebuggedProject() {
        return this.fieldDebuggedProject;
    }

    public void setDebuggedProject(IProject debuggedProject) {
        this.fieldDebuggedProject = debuggedProject;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.fieldStatusLineManager;
    }

    public void setStatusLineManager(IStatusLineManager statusLineManager) {
        this.fieldStatusLineManager = statusLineManager;
    }

    @Override
    public RecordingSettings settings() {
        return this.fieldSettings;
    }

    @Override
    public void setSettings(RecordingSettings settings) {
        this.fieldSettings = settings;
    }

    public URL jarLocation(String entryName, String jarName) {
        URL jarURL = null;
        URL bundleEntry = DromiActivator.getDefault().getBundle().getEntry(entryName);
        try {
            jarURL = FileLocator.toFileURL((URL)bundleEntry);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to use FileLocator to find " + jarName + " jar location.", e);
        }
        return jarURL;
    }

    @Override
    public URL thorJarLocation() {
        return this.jarLocation("resources/thor-2.0.4.jar", "Thor");
    }

    @Override
    public URL dromiShivJarLocation() {
        return this.jarLocation("resources/dromi-shiv-0.0.6.jar", "Dromi Shiv");
    }

    public EclipseRecordingContext(RecordingSettings settings, IWorkbenchWindow window, IStatusLineManager manager, IProject debuggedProject, IJavaDebugTarget debugContext, IJavaVariable variable) {
        this.setSettings(settings);
        this.setWindow(window);
        this.setStatusLineManager(manager);
        this.setDebuggedProject(debuggedProject);
        this.setDebugContext(debugContext);
        this.setSelectedVariable(variable);
    }

    protected IWorkbench workbench() {
        return PlatformUI.getWorkbench();
    }

    protected Shell shell() {
        return this.getWindow().getShell();
    }

    protected void async(Runnable r) {
        this.workbench().getDisplay().asyncExec(r);
    }

    @Override
    public void showErrorDialog(ErrorDialogBean dialog) {
        this.async(() -> ErrorDialog.openError(null, (String)dialog.getWindowTitle(), (String)dialog.getMessage(), (IStatus)dialog.getStatus()));
    }

    @Override
    public void showErrorMessage(String title, String message) {
        this.async(() -> MessageDialog.openError((Shell)this.shell(), (String)title, (String)message));
    }

    @Override
    public void showWarningMessage(String title, String message) {
        this.async(() -> MessageDialog.openWarning((Shell)this.shell(), (String)title, (String)message));
    }

    @Override
    public void showInformationMessage(String title, String message) {
        this.async(() -> MessageDialog.openInformation((Shell)this.shell(), (String)title, (String)message));
    }

    @Override
    public boolean showQuestionDialog(String title, String body) {
        AtomicBoolean value = new AtomicBoolean();
        this.workbench().getDisplay().asyncExec(() -> value.set(MessageDialog.openQuestion((Shell)this.shell(), (String)title, (String)body)));
        return value.get();
    }

    @Override
    public void setStatusLineMessage(String string) {
        this.getStatusLineManager().setMessage(string);
    }

    @Override
    public void setStatusLineError(String string) {
        this.getStatusLineManager().setErrorMessage(string);
    }

    @Override
    public boolean pathExists(Path path) {
        EclipseContextPathVaildator validator = new EclipseContextPathVaildator();
        return validator.exists(path);
    }

    @Override
    public Path projectLocation() {
        return this.getDebuggedProject().getLocation().toPath();
    }

    @Override
    public void refreshProjects() {
        try {
            IWorkspaceRoot root = this.getDebuggedProject().getWorkspace().getRoot();
            IProject[] iProjectArray = root.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject currentProject = iProjectArray[n2];
                currentProject.refreshLocal(2, null);
                ++n2;
            }
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    @Override
    public Boolean variableExistsInStack(String variableName) {
        try {
            if (this.getDebugContext().findVariable(variableName) != null) {
                return true;
            }
            return false;
        }
        catch (DebugException e) {
            this.handleDebugException(e);
            return null;
        }
    }

    @Override
    public String variableName() {
        return this.variable().getName();
    }

    @Override
    public String variableClassname() {
        return this.variable().getClassname();
    }

    @Override
    public String variablePackage() {
        return this.variable().getPackage();
    }

    @Override
    public String variableNameForPathing() {
        return this.variable().getNameForPathing();
    }

    @Override
    public void setVariableNameForPathing(String name) {
        this.variable().setNameForPathing(name);
    }

    protected void handleDebugException(DebugException exception) {
        throw new RuntimeException("Dromi encountered an error while interacting with Eclipse's JDI interface.", exception);
    }

    protected void handleCoreException(CoreException exception) {
        throw new RuntimeException("Dromi encountered an error while interacting with Eclipse.", exception);
    }

    @Override
    public void showWizard(EclipseWizardConfigurationBean configuration, Wizard wizard) {
        WizardDialog dialog = new WizardDialog(this.shell(), (IWizard)wizard);
        dialog.setPageSize(configuration.getPageWidth(), configuration.getPageHeight());
        dialog.setBlockOnOpen(configuration.isBlocking());
        this.workbench().getDisplay().syncExec(() -> dialog.open());
    }
}

