/*
 * Decompiled with CFR 0.152.
 */
package com.advancedpwr.eclipse.dromi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class CachedDestinationManager {
    public static final String PATHS_CACHE_PROPERTIES = "paths_cache.properties";
    protected File fieldCacheFile;
    protected Properties fieldPropertiesCache;

    protected File getCacheFile() {
        return this.fieldCacheFile;
    }

    protected void setCacheFile(File cacheFile) {
        this.fieldCacheFile = cacheFile;
    }

    protected Properties getPropertiesCache() {
        return this.fieldPropertiesCache;
    }

    protected void setPropertiesCache(Properties propertiesCache) {
        this.fieldPropertiesCache = propertiesCache;
    }

    protected void loadPropertiesCache(File cacheFile) throws FileNotFoundException, IOException {
        Properties cache = new Properties();
        if (!this.getCacheFile().exists()) {
            this.getCacheFile().createNewFile();
        }
        cache.load(new FileReader(this.getCacheFile()));
        this.setPropertiesCache(cache);
    }

    public CachedDestinationManager(IPath pluginCacheDirectory) throws FileNotFoundException, IOException {
        this.setCacheFile(pluginCacheDirectory.append(PATHS_CACHE_PROPERTIES).toFile());
        this.loadPropertiesCache(this.getCacheFile());
    }

    public String getPathForProject(IProject project) {
        if (project.getLocationURI() == null) {
            return "";
        }
        return this.getPropertiesCache().getProperty(project.getLocationURI().toString(), "");
    }

    public boolean setPathForProject(IProject project, String path) throws IOException {
        if (project.getLocationURI() == null) {
            return false;
        }
        this.getPropertiesCache().setProperty(project.getLocationURI().toString(), path);
        this.getPropertiesCache().store(new FileWriter(this.getCacheFile()), "");
        return true;
    }
}

